## Is Operator

Checks that two MDX entities are the same.




### Description

The `IS` operator is used to check that two MDX objects are referring to the same MDX entities (e.g., member, tuple, level, hierarchy, etc...). It must not be confused with the `=` operator that is operating on scalar values.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Members

</div>

<div class="ic3-mdx-example-body" style="display:none">

The IS operator is very often used to check actual currentMember; in this example we're checking that the currentMember on rows is [Europe] and display a boolean value accordingly.

**Query**

```
[Geography].[Geo].currentMember is [Geography].[Geo].[Continent].[Europe]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>false</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### More than members

</div>

<div class="ic3-mdx-example-body" style="display:none">

The IS operator can be used to check any MDX entity: e.g., member, level, tuples, etc...

**Query**

```
with
    member [Same Level]     as [Geography].[Geo].[Continent].[Europe].level is [Geography].[Geo].[Continent]
    member [Same Hierarchy] as [Geography].[Geo].[Continent].[Europe].hierarchy is [Geography].[Geo]
    member [Same Tuple]     as ( [Geography].[Geo].[Continent].[Europe], [Measures].[Amount] ) is ( [Geography].[Geo].[Continent].[Europe], [Measures].[Amount] )
select
    { [Same Level], [Same Hierarchy], [Same Tuple] } on 0
from
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Same Level</td>
  <td class="ic3-mdx-result-cell-header">Same Hierarchy</td>
  <td class="ic3-mdx-result-cell-header">Same Tuple</td>
</tr>
<tr>
 <td>true</td>
 <td>true</td>
 <td>true</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Versus the '=' operator

</div>

<div class="ic3-mdx-example-body" style="display:none">

The IS operator must not be confused with the = operator. The = operator is comparing scalar values whereas the IS operator is acting on MDX entities like member, level, etc... In this example, we can see that the member [x] is not the member [y] whereas the value of [x] equals the value of [y].

**Query**

```
with
    member [x]      as 1
    member [y]      as 1
    member [x is y] as [x] is [y]
    member [x = y]  as [x] = [y]
select
    { [x], [y], [x is y], [x = y] } on 0
from
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">x</td>
  <td class="ic3-mdx-result-cell-header">y</td>
  <td class="ic3-mdx-result-cell-header">x is y</td>
  <td class="ic3-mdx-result-cell-header">x = y</td>
</tr>
<tr>
 <td>1</td>
 <td>1</td>
 <td>false</td>
 <td>true</td>
</tr>
</table>



 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
